(function(window) {

	// TODO: wiki
	// TODO: progress bar should be terminated if any error occurs (try use `throw`)
	// TODO: gifs will be attached in not the same order they are selected but in the order of MB size (small first, big last)

	var ACCESS_TOKEN = window.mpACCESS_TOKEN;
	var USER_ID = window.mpUSER_ID;
	var UPLOAD_SERVER_URL = window.mpUPLOAD_SERVER_URL;
	var GA_ID = 'UA-61260312-1';  // Identifier for Google Analytics

	// Main module
	var module = mainModule();
	// Cache module
	var gifCache = cacheModule();
	// Google Analytics module
	var STAT = statModule();
	// Android interface
	var ANDROID = window._MobilePluginLoader || null;

	if (!ANDROID) return console.log('No Android interface');

	STAT.init();
	module.init();

	if (!window.__MOBILE_PLUGIN_GIF) {
		window.__MOBILE_PLUGIN_GIF = module;
	}

	checkSelectedGif();


	/**
	 * A number, or a string containing a number.
	 * @typedef {(number|string)} NumberLike
	 */

	/**
	 * @typedef {Object}        DocCacheObject
	 * @property {NumberLike}   ownerId - ID of the user, owner of the document
	 * @property {NumberLike}   docId   - ID of the document
	 * @property {string}       title   - Document's title
	 */


	function checkSelectedGif() {
		var gif = _VkTheme.getItem('gif_selected');
		var sendSelectedGif = function () {
			window.parent.postMessage(gif, '*');
		};

		if (gif) {
			_VkTheme.removeItem('gif_selected');
			gif = JSON.parse(gif);
			gif.act = 'gifSelected';

			if (!ACCESS_TOKEN) {
				getToken(sendSelectedGif);
			} else {
				sendSelectedGif();
			}
		}
	}


	function getToken(callback) {
		window.getVkTokenCallback = window.getVkTokenCallback || function getVkTokenCallback(userId, token, error, errorMsg) {
			if (!error) {
				ACCESS_TOKEN = token;
				USER_ID = userId;

				window.mpACCESS_TOKEN = ACCESS_TOKEN;
				window.mpUSER_ID = USER_ID;
			} else {
				// TODO: handle errors
				alert('Ошибка получения токена');
				console.log('token error: ' + errorMsg);
			}

			if (typeof callback === 'function') {
				callback();
			}
		};

		ANDROID.getVkToken('getVkTokenCallback([$UserId], [$VkToken], [$isError], [$ErrorMessage])');
	}

	function mainModule() {

		var API_VERSION = '5.37';
		var API_URL = 'https://api.vk.com/method/';
		var HOME_URL = '//newth.orbitum.com/promo_en';

		var BUTTON_ID = 'gifButton';
		var GIF_POPUP_ID = '__giffed_popup';
		var POPUP_BOX_LOADER_ID = 'popup_box_loader';

		var MAX_ATTACHMENT_COUNT = 10;
		var MAX_GIFS_ALLOWED = 1;

		var captchaShown = false;  // Is captcha popup displayed right now
		var captchaReqs = [];  // Array to store requests blocked by captcha

		var attachedGifs = [];  // This is for GA
		var docsList = {};  // This is for interal procedures, flushes when gif is attached

		window.jsonpCallbacks = { counter: 0 };

		/**
		 * @access public
		 */
		function init() {
			var el = document.getElementById('vk_wrap');

			if (!el) {
				return console.log('No vk_wrap.');
			}

			insertIntoMessages();

			el.addEventListener('DOMNodeInserted', insertIntoMessages);
			window.addEventListener('message', gifPopupEventListener);
		}

		/**
		 * Listens events from GIFs popup.
		 */
		function gifPopupEventListener(event) {
			var data = event.data;

			switch (data.act) {
				case 'gifPopupLoaded':
					removePopupLoader();
					showPopup();

					break;

				case 'gifSelected':
					if (!docsList[data.title]) {
						docsList[data.title] = {
							category: data.category,    // Category of the gif
							progressBar: new ProgressBar( getAttachmentsContainer() ),
							sent: false,            	// Boolean flag to show if this gif was already sent to android uploader
							tags: 'orbitum,gif',    	// Default tags separated by comma which will be added to VK doc
							title: data.title,          // Title of the gif
							url: data.url				// URL of the gif at Giphy.com
						};

						attachGif(data);
					} else {
						// TODO: what to do when user tries to attach one gif more than once?
						// reject for now
						console.log("No way! I've already attached that gif.");
					}

					removePopup();

					break;

				case 'closePopup':
					removePopup();

					break;
			}
		}

		function showGifButton(show) {
			var el = document.getElementById(BUTTON_ID);
			if (el) {
				el.style.display = show ? 'block':'none';
			}
		}

		/**
		 * Inserts GIF button into IM dialogs.
		 */
		function insertIntoMessages() {
			var form = document.getElementById('write_form');
			var submit = document.getElementById('write_submit');
			var el, block;

			// If button is already inserted then do nothing
			if (document.getElementById(BUTTON_ID)) {
				return;
			}

			if (form) {
				el = document.createElement('span');
				el.id = BUTTON_ID;
				el.className = 'cp_icon_btn';
				el.style.background = 'url(' + HOME_URL + '/gifv2.png) no-repeat';
				el.style.width = '22px';
				el.style.height = '13px';
				el.style.margin = '10px 5px 0 0';
				el.style.position = 'absolute';
				el.style.right = '99px';
				el.style.top = '7px';
				el.onclick = function gifButton_onClick(e) {
					var redirect = encodeURIComponent( window.location.toString() );
					var url = 'http://newth.orbitum.com/promo_en/gif_collect/index.html?redirect=' + redirect;
					var getTokenCallback = function () {
						window.location = url;
					};

					if (!ACCESS_TOKEN || !USER_ID) {
						getToken(getTokenCallback);
					} else {
						getTokenCallback();
					}

					/*var attachmentList = getAttachmentsContainer();
					var alreadyAttached = attachmentList && attachmentList.children.length;
					var canAttach = alreadyAttached < MAX_ATTACHMENT_COUNT;

					e.stopPropagation();

					if (canAttach) {
						generatePopup();
					}*/
				};

				block = form.getElementsByClassName('cp_buttons_block');
				if (block.length) {
					block[0].style.position = 'relative';
					block[0].appendChild(el);
				}
			}

			if (submit) {
				submit.addEventListener('click', function() {
					var l = attachedGifs.length;

					if (l) {
						STAT.send_uniq();
					}

					for (var i = 0; i < l; i++) {
						STAT.send('send_gif', 'category_' + attachedGifs[i].category);
					}

					attachedGifs = [];
					showGifButton(true);
				});
			}
		}

		/**
		 * Receives gif's info as `data` argument from GIFs popup.
		 */
		function attachGif(data) {
			var cached = gifCache.get(USER_ID, data.title);

			if (cached) {
				console.log('cache');
				attachFileFromCache(data, cached);
			} else {
				console.log('no cache');
				attachNewFile(data);
			}
		}

		function attachFileFromCache(recent, cached) {
			// First check if cached doc is still exists in VK docs
			console.log('check ' + cached.ownerId + '_' + cached.docId);
			jsonp('docs.getById', { docs: cached.ownerId + '_' + cached.docId }, ACCESS_TOKEN, 'checkDocCallback');

			window.checkDocCallback = function checkDocCallback(res) {
				if (!res || !res.response) {
					return console.log('Check document failed: ' + JSON.stringify(res));
				}

				if (res.response.length === 0) {
					// Empty response means the cached gif is not exists anymore
					console.log('Invalid cache');
					// Remove the gif from cache
					gifCache.remove(USER_ID, recent.title);
					// Retry without cache
					attachGif(recent);
				} else {
					console.log('Very good cache!');
					docsList[recent.title].progressBar.remove(function() {
						cached.category = recent.category;
						renderIMAttachmentTpl(cached);
						delete docsList[recent.title];
					});
				}
			};
		}

		function attachNewFile(data) {
			if (!ACCESS_TOKEN) {
				// TODO: request token and retry to attach file
				// getToken();
				// document.addEventListener('token', onGetToken);

				docsList[data.title].progressBar.remove();
				delete docsList[data.title];

				return console.log("Can't proceed doc upload: access token required.");
			}

			if (!UPLOAD_SERVER_URL) {
				jsonp('docs.getUploadServer', {}, ACCESS_TOKEN, 'getUploadServerCallback');

				window.getUploadServerCallback = function getUploadServerCallback(res) {
					if (res && res.response && res.response.upload_url) {
						UPLOAD_SERVER_URL = res.response.upload_url;
						uploadFile(data);
					} else {
						// TODO: handle errors
					}
				};
			} else {
				uploadFile(data);
			}
		}

		function onGetToken() {
			console.log('TOKEN ' + ACCESS_TOKEN);
		}

		function uploadFile(data) {
			if (!data.sent) {
				ANDROID.uploadFile(
					UPLOAD_SERVER_URL,
					data.url,
					data.title + '.gif',
					'image/gif',
					'window.' + generateCallback(data.title, uploadDocCallback) +  '([$answer],[$isError],[$ErrorMessage])'
				);
				data.sent = true;
			}
		}

		function uploadDocCallback(key, res, err, errorMessage) {
			if (!err) {
				if (!res.error) {
					saveDoc(key, res.file);
				} else {
					// TODO: handle errors
					console.log('error ' + JSON.stringify(res.error));
				}
			} else {
				// TODO: handle errors
				console.log(JSON.stringify(errorMessage));

				docsList[key].progressBar.remove();
				delete docsList[key];
			}
		}

		/**
		 * @access public
		 */
		function saveDoc(key, fileInfo) {
            var doc = docsList[key];

            jsonpParam(
                key,
                'docs.save',
                {
                    file: fileInfo,
                    title: doc.title,
                    tags: doc.tags || ''
                },
                ACCESS_TOKEN,
                saveDocCallback
            );
        }

		function saveDocCallback(key, res) {
			var doc = docsList[key];
			var data;

			if (res.error) {
				switch (res.error.error_code) {
					case 14:
						// Captcha needed
						console.log('captcha');
						captchaReqs.push({ key: key, res: res });
						captchaShown || showCaptchaPopup(key, res.error.captcha_img);
						break;

					default:
						console.log(res.error.error_msg);
						doc.progressBar.remove();
						break;
				}

				return;
			}

			data = res.response[0];

			// TODO: there is html "jumping" between progress bar removal and template insertion.
			// Need a common wrapper into wich progress bar and template both will be inserted.
			doc.progressBar.remove(function() {
				module.renderIMAttachmentTpl({
					category: doc.category,
					title: doc.title,
					ownerId: data.owner_id,
					docId: data.id
				});
			});

			gifCache.add({
				ownerId: data.owner_id,
				docId: data.id,
				title: doc.title
			});

			delete docsList[key];

			console.log('Doc saved ' + JSON.stringify(res));
		}

		// TODO: handle case when two or more requests return "Captcha needed" errors
		function showCaptchaPopup(key, captchaImg) {
			console.log('show captcha popup');
			// TODO: check if popup size needs to be not-fixed
			var captchaTemplate = '<div id="box_layer" style="position:fixed;width:100%;z-index:30;top:0;margin-top:100px"><div id="box_loader"><div class="loader"></div><div class="back"></div></div><div style="width:305px;height:auto;margin-top:250px;margin:0 auto;z-index:10;background:#fff"><div class="box_layout" style="font-family:tahoma,arial,verdana,sans-serif,Lucida Sans;font-size:11px;line-height:1.182;font-weight:400;-webkit-font-smoothing:subpixel-antialiased"><div class="box_title_wrap" style="background-color:#597BA5;border-color:#45688E #43658A;padding:0;color:#fff;border:none;font-size:1em;font-weight:400"><div class="box_x_button" style="float:right;width:17px;height:17px;margin:7px 5px 0;cursor:pointer;padding:0;background:#9db7d4 url(/images/boxicon_vk.gif) -23px -2px;background:0 0;margin:0;padding:17px 20px 15px;color:#C7D7E9;width:auto">Закрыть</div><div class="box_title" style="border-top:1px solid #648CB7;padding:6px 10px 8px 10px;border:none;color:#FFF;background:#597BA5;font-weight:700;padding:17px 20px 18px;font-size:1.09em;overflow:hidden;text-overflow:ellipsis;white-space:nowrap">Введите код с картинки</div></div><div class="box_body" style="background-color:#FFF;border-left:1px solid #999;border-right:1px solid #999;padding:16px 14px;line-height:140%;border:none"><div class="captcha" style="padding:5px 0;text-align:center;height:80px"><div><img src="{captcha_img}"></div><div><input class="captcha_input" maxlength="7" placeholder="Введите код сюда" style="background:#FFF;color:#000;border:1px solid #C3CBD4;padding:3px;margin:0;font-size:1.09em!important;padding:5px 4px 4px;font-size:11px;font-family:Tahoma,Verdana,Arial,Sans-Serif,Lucida Sans;display:inline-block;font-size:1em!important;margin-top:7px"><div class="progress" style="display:none"></div></div></div></div><div class="box_controls_wrap" style="border:1px solid #999;border-top:0;border:none"><div class="box_controls" style="padding:8px 5px;height:26px;background-color:#F2F2F2;border-top:1px solid #DAE1E8;border:none;padding:16px 15px 16px 20px;background-color:#F7F7F7"><table cellspacing="0" cellpadding="0" class="fl_r" style="float:right"><tbody><tr><td><button class="captcha_button" style="padding:6px 16px 7px 16px;margin:0;font-size:11px;display:inline-block;zoom:1;cursor:pointer;white-space:nowrap;outline:0;font-family:tahoma,arial,verdana,sans-serif,Lucida Sans;vertical-align:top;overflow:visible;line-height:13px;text-decoration:none;background:0 0;background-color:#6383a8;color:#FFF;border:0;-webkit-border-radius:2px;-khtml-border-radius:2px;-moz-border-radius:2px;-ms-border-radius:2px;border-radius:2px;-webkit-transition:background-color .1s ease-in-out;-khtml-transition:background-color .1s ease-in-out;-moz-transition:background-color .1s ease-in-out;-ms-transition:background-color .1s ease-in-out;-o-transition:background-color .1s ease-in-out;transition:background-color .1s ease-in-out;margin-left:10px">Отправить</button></table></div></div></div></div></div>';

			var bg = document.createElement('div');
			var form = document.createElement('div');

			bg.id = 'captcha-bg';
			bg.style.height = '100%';
			bg.style.width = '100%';
			bg.style.backgroundColor = '#000';
			bg.style.opacity = '0.7';
			bg.style.position = 'fixed';
			bg.style.top = '0';
			bg.style.overflow = 'hidden';
			bg.style.webkitTransition = 'opacity .3s';
			bg.style.transition = 'opacity .3s';
			bg.style.zIndex = '20';

			form.insertAdjacentHTML( 'beforeend', captchaTemplate.replace(/{captcha_img}/, captchaImg) );

			document.body.appendChild(bg);
			document.body.appendChild(form);

			document.querySelector('.box_x_button').addEventListener('click', removeCaptchaPopup.bind(this, key));
			document.querySelector('.captcha_button').addEventListener('click', submitCaptcha);

			captchaShown = true;

			lockScroll();
		}

		function removeCaptchaPopup(key) {
			unlockScroll();

			removeElementById('captcha-bg');
			removeElementById('box_layer');

			if (key) {
				docsList[key].progressBar.remove();
				delete docsList[key];
			}

			captchaShown = false;
		}

		function submitCaptcha() {
			var value = document.querySelector('.captcha_input').value;
			var params, req, data, key, res;

			while (captchaReqs.length > 0) {
				data = captchaReqs.shift();
				key = data.key;
				res = data.res;
				req = res.error.request_params;
				params = {};

				for (var k = 0, l = req.length; k < l; k++) {
					params[ req[k].key ] = req[k].value;
				}

				jsonpParam(
					key,
					'docs.save',
					{
						file: params.file,
						title: params.title,
						tags: params.tags,
						captcha_sid: res.error.captcha_sid,
						captcha_key: value
					},
					ACCESS_TOKEN,
					saveDocCallback
				);
			}

			removeCaptchaPopup();
		}

		function lockScroll() {
			document.body.scrollTop = '1';
			// document.body.addEventListener('touchmove', blockScroll);
		}

		function unlockScroll() {
			document.body.scrollTop = '0';
			// document.body.removeEventListener('touchmove', blockScroll);
		}

		function blockScroll(e) {
			e.preventDefault();
		}

		/**
		 * Removes popup spin loader.
		 */
		function removePopupLoader() {
			unlockScroll();
			removeElementById(POPUP_BOX_LOADER_ID);
			document.body.removeEventListener('click', removePopupLoader);
		}

		/**
		 * Generates HTML for GIFs popup and inserts it invisible into DOM.
		 */
		function generatePopup() {
			var div = document.createElement('div');
			var loader = document.getElementById(POPUP_BOX_LOADER_ID);

			if (!loader) {
				document.body.insertAdjacentHTML('beforeend', '<div id="' + POPUP_BOX_LOADER_ID + '" style="z-index:999;position:fixed;left:50%;top:40%;margin:0 auto 0 -50px;width:100px;display:block;">' +
				'<div class="loader" style="background:url(/images/upload_inv_mono.gif) 50% 50% no-repeat;height:50px;position:absolute;width:100%;z-index:100;"></div>'+
				'<div class="back" style="background-color:#000;opacity:.7;filter:alpha(opacity=70);height:50px;-webkit-border-radius:5px;-khtml-border-radius:5px;-moz-border-radius:5px;border-radius:5px;-webkit-box-shadow:0 2px 10px rgba(0,0,0,.35);-moz-box-shadow:0 2px 10px rgba(0,0,0,.35);box-shadow:0 2px 10px rgba(0,0,0,.35);"></div>'+
				'</div>');

				document.body.addEventListener('click', removePopupLoader);
			}

			div.innerHTML = '<div class="popup_box_container" style="width: 100%; height: 100%; margin: 0px auto; background: white !important;">' +
				'<div class="preloader_gif"></div>' +
				'<iframe id="gif_frame" src="//newth.orbitum.com/promo_en/gif_collect/index.html" style="display:block; width:100%; height: 100%;border: 0px;"></iframe>' +
				'</div>';
			div.id = GIF_POPUP_ID;
			div.setAttribute('style', 'position: fixed; top: 0; left: 0; height: 100%;width: 100%; z-index: 999999999;display:none');

			document.body.appendChild(div);
		}

		/**
		 * Makes GIFs popup visible.
		 */
		function showPopup() {
			var popup = document.getElementById(GIF_POPUP_ID);
			if (popup) {
				lockScroll();
				popup.style.display = 'block';
			}
		}

		/**
		 * Completely removes GIFs popup from DOM.
		 */
		function removePopup() {
			unlockScroll();
			removeElementById(GIF_POPUP_ID);
		}

		/**
		 * Creates visual representation of gif doc attached to message.
		 *
		 * @param {Object} params Hash with attributes: title, ownerId, docId, category
		 * @access public
		 */
		function renderIMAttachmentTpl(params) {
			var attachmentList = getAttachmentsContainer();
			var attachmentNumber = attachedGifs.length + 1;
			var tpl = '<div class="medias_row mr_x_wrap">' +
				'<span class="mr_label medias_link">' +
				'<span class="medias_link_icon"><i class="i_icon i_doc"></i></span>' +
				'<span class="medias_link_label">Файл</span> ' +
				'<span class="medias_link_labeled medias_link_title">{attachment_title}</span>' +
				'<span class="medias_link_desc">Файл</span>' +
				'</span>' +
				'<div class="tu_cancel_wrap" onclick="__MOBILE_PLUGIN_GIF.removeAttachment(this,{attachment_id});">' +
				'<i class="tu_cancel"></i>' +
				'</div>' +
				'<input type="hidden" name="attach{attachment_number}_type" value="doc">' +
				'<input type="hidden" name="attach{attachment_number}" value="{owner_id}_{attachment_id}">' +
				'</div>';

			tpl = tpl.replace(/{attachment_title}/, params.title)
				.replace(/{attachment_number}/g, attachmentNumber)
				.replace(/{owner_id}/g, params.ownerId)
				.replace(/{attachment_id}/g, params.docId);

			attachmentList.insertAdjacentHTML('beforeend', tpl);

			attachedGifs.push({
				category: params.category,
				ownerId: params.ownerId,
				docId: params.docId,
				title: params.title
			});

			showGifButton( attachedGifs.length < MAX_GIFS_ALLOWED );
		}

		/**
		 * Removes attached doc.
		 *
		 * @access public
		 */
		function removeAttachment(e, docId) {
			var attachmentWrap, attachmentList, attachments, inputs, attachmentNumber = 1;
			var filtered = false;
			var attachmentRow = e.parentNode;

			// Remove gif by its id from attachedGifs array
			attachedGifs = attachedGifs.filter(function(item) {
				// Check if array was already filtered
				// (in case the same gif was added more than once)
				if (!filtered && item.docId === docId) {
					filtered = true;
					return false;
				}

				return true;
			});

			showGifButton( attachedGifs.length < MAX_GIFS_ALLOWED );

			// Remove attachment row from DOM
			attachmentRow.parentNode.removeChild(attachmentRow);

			// Update attachments ids
			attachmentWrap = document.getElementById('attached_wrap');
			attachmentList = attachmentWrap && attachmentWrap.getElementsByClassName('pi_medias')[0];
			attachments = attachmentList && attachmentList.children;

			for (var i = 0, l = attachments.length; i < l; i++) {
				inputs = attachments[i].getElementsByTagName('input');
				for (var k = 0, il = inputs.length; k < il; k++) {
					// Check for `attach` word also to replace attachment inputs only
					inputs[k].name = inputs[k].name.replace(/attach\d+/, 'attach' + attachmentNumber);
				}
				attachmentNumber++;
			}
		}

		function getAttachmentsContainer() {
			var attachmentWrap = document.getElementById('attached_wrap');
			var attachmentList = attachmentWrap && attachmentWrap.getElementsByClassName('pi_medias')[0];
			if (!attachmentList) {
				attachmentList = document.createElement('div');
				attachmentList.className = 'pi_medias';
				attachmentWrap.appendChild(attachmentList);  // TODO: if there's no attachmentWrap?
			}

			attachmentList.style.display = 'block';

			return attachmentList;
		}

		/**
		 * Prepares JSONP request -- make url and inject script tag into page.
		 *
		 * @param  {String}   methodName   Name of the VK API method
		 * @param  {Object}   methodParams Hash  object of paramName:paramValue pairs
		 * @param  {String}   token        Access token
		 * @param  {String}   callback     Function to be called after method invocation
		 */
		function jsonp(methodName, methodParams, token, callback) {
			methodParams.v = API_VERSION;
			methodParams.access_token = token;
			methodParams.callback = callback;
			console.log(methodName + ' ' + JSON.stringify(methodParams));
			injectScript( API_URL + methodName + combineParams(methodParams, '?') );
		}

		/**
		 * Calls `jsonp` with generated callback function.
		 *
		 * @param  {String}   gifKey       Attribute of the gif object that is used as key in `docsList`
		 * @param  {String}   methodName   Name of the VK API method
		 * @param  {Object}   methodParams Hash  object of paramName:paramValue pairs
		 * @param  {String}   token        Access token
		 * @param  {Function} callback     Function to be called after method invocation
		 */
		function jsonpParam(gifKey, methodName, methodParams, token, callback) {
			var genCallback = generateCallback(gifKey, callback);
			jsonp(methodName, methodParams, token, genCallback);
		}

		/**
		 * Generates global callback with special `gifKey` param.
		 *
		 * @param  {String}   gifKey Attribute of the gif object that is used as key in `docsList`
		 * @param  {Function} fn     Callback function for the JSONP request
		 * @return {String}          Name of the callback in global namespace
		 */
		function generateCallback(gifKey, fn) {
			var name = 'fn' + window.jsonpCallbacks.counter++;

			window.jsonpCallbacks[name] = function() {
				var args = Array.prototype.slice.call(arguments);
				args.unshift(gifKey);
				fn.apply(this, args);

				// upon success, remove callback
				delete window.jsonpCallbacks[name];
			};

			return 'jsonpCallbacks.' + name;
		}

		return {
			init: init,
			renderIMAttachmentTpl: renderIMAttachmentTpl,
			removeAttachment: removeAttachment,
            saveDoc: saveDoc
		};
	}

	// TODO: will not work if add the same gif twice — would cause duplicate keys. Deal with it B-) or generate uniq keys
	function ProgressBar(container) {
		var WRAP_PREFIX = 'gif_progress_wrap_';
		var BAR_PREFIX = 'gif_progress_';
		var MAX_VALUE = 100;

		this.container = container;
		this.barId = new Date().getTime();
		this.wrapId = WRAP_PREFIX + this.barId;
		this.bar1Id = BAR_PREFIX + 1 + this.barId;
		this.bar2Id = BAR_PREFIX + 2 + this.barId;

		this._getBar = function(first) {
			return document.getElementById(first ? this.bar1Id : this.bar2Id);
		};

		this._createBar = function() {
			var divWrapper = document.createElement('div');
			var divInner1 = document.createElement('div');
			var divInner2 = document.createElement('div');

			divWrapper.id = this.wrapId;
			divWrapper.style.backgroundColor = '#ABAEB2';
			divWrapper.style.borderRadius = '5px';
			divWrapper.style.margin = '12px 5px 4px 5px';
			divWrapper.style.padding = '1px';
			divWrapper.style.position = 'relative';
			divWrapper.style.webkitTransition = 'opacity .5s';
			divWrapper.style.transition = 'opacity .5s';

			divInner1.id = this.bar1Id;
			divInner1.className = 'first-bar';
			divInner1.style.height = '6px';
			divInner1.style.width = '0px';
			divInner1.style.backgroundColor = '#4C6B8F';

			divInner2.id = this.bar2Id;
			divInner2.className = 'second-bar';
			divInner2.style.height = '6px';
			divInner2.style.width = '0px';
			divInner2.style.backgroundColor = '#ABAEB2';
			divInner2.style.position = 'absolute';
			divInner2.style.top = '1px';

			divWrapper.appendChild(divInner1);
			divWrapper.appendChild(divInner2);

			return divWrapper;
		};

		this._bringToTop = function(first) {
			var bar1 = this._getBar(first);
			var bar2 = this._getBar(!first);

			bar1.style.zIndex = 1;
			bar2.style.zIndex = -1;
		};

		this._startAnimation = function() {
			var first = true;
			var inc = 2;
			var reset = false;

			this._animateFn = function() {
				var el = this._getBar(first);
				var width = el && parseInt(el.style.width, 10);

				if (reset) {
					this._bringToTop(first);
					width = 0;
					reset = !reset;
				}

				if (el && !el.stopped) {
					if (width + inc <= MAX_VALUE) {
						width += inc;
						el.style.width = width + '%';
						setTimeout(this._animateFn.bind(this), 30);
					} else {
						first = !first;
						reset = true;
						this._animateFn();
					}
				}
			};

			this._animateFn();
		};

		this.container.appendChild( this._createBar() );
		this._startAnimation();

		return this;

	}

	ProgressBar.prototype.remove = function(callback) {
		var elWrap = document.getElementById(this.wrapId);

		if (elWrap) {
			elWrap.style.opacity = 0;
			setTimeout(function() {
				elWrap.parentNode.removeChild(elWrap);
				if (callback) callback();
			}, 500);

		}
	};

	/**
	 * Recent gifs cache allows to select a gif from local storage and not
	 * to upload it to user's documents again.
	 */
	function cacheModule() {
		var storageName = 'gif_cache';
		/**
		 * @type {DocCacheObject}
		 */
		var storage = _VkTheme.getItem(storageName);
		var cache = storage && JSON.parse(storage) || {};

		function saveStorage() {
			_VkTheme.setItem(storageName, JSON.stringify(cache));
		}

		return {
			/**
			 * Retrieve gif's data from cache.
			 * @param  {NumberLike} ownerId ID of the user
			 * @param  {String}     title   Title of the gif
			 * @return {?DocCacheObject} 	Gif's data or `undefined`
			 */
			get: function(ownerId, title) {
				console.log('get cache ' + ownerId + ' ' + title);
				// this.ls();
				return cache[ownerId + title];
			},
			/**
			 * Add gif's data to the cache and save it to _VkTheme.
			 * @param {DocCacheObject} item - Gif's data
			 */
			add: function(item) {
				console.log('set cache ' + item.ownerId + ' ' + item.title + ' ' + item.docId);
				cache[item.ownerId + item.title] = {
					ownerId: item.ownerId,
					docId: item.docId,
					title: item.title
				};
				saveStorage();
			},
			/**
			 * Clear the cache item.
			 * @param  {NumberLike} ownerId ID of the user
			 * @param  {String}     title   Gif's title
			 */
			remove: function(ownerId, title) {
				if (cache[ownerId + title]) {
					delete cache[ownerId + title];
					saveStorage();
				}
			},
			reset: function() {
				_VkTheme.removeItem(storageName);
				cache = {};
				console.log('reset cache');
			},
			ls: function() {
				for (var c in cache) {
					console.log('c: ' + cache[c].title + ' ' + cache[c].ownerId + ' ' + cache[c].docId);
				}
			}
		};
	}

	function statModule() {
		return {
			history: {},
			isNew: true,
			cacheName: 'gif_stat_cache',

			init: function() {
				var tmp = _VkTheme.getItem(this.cacheName);

				this.injectGA();

				if (!tmp) {
					return this;
				}

				this.isNew = false;
				this.history = JSON.parse(tmp);
				return this;
			},

			injectGA: function() {
				(function(i, s, o, g, r, a, m) {
				    i['GoogleAnalyticsObject'] = r;
				    i[r] = i[r] || function() {
				        (i[r].q = i[r].q || []).push(arguments);
				    }, i[r].l = 1 * new Date();
				    a = s.createElement(o), m = s.getElementsByTagName(o)[0];
				    a.async = 1;
				    a.src = g;
				    m.parentNode.insertBefore(a, m);
				})(window, document, 'script', '//www.google-analytics.com/analytics.js', 'ga');
				ga('create', GA_ID, 'auto');
			},

			send_uniq: function() {
				if (this.isNew) {
					this.send('send_uniq');
					this.save();
				}
			},

			send: function(event, label) {
				console.log('ga ' + event + ' ' + (label || ''));
				this.procc(event);
				window.ga('send', 'event', 'MOBILE_GIF', event, label || '');
			},

			procc: function(event) {
				if (event !== "send_gif") {
					return;
				}
				var dt = new Date().getDay();

				if (this.history.dt !== dt) {
					this.history.dt = dt;
					this.history[event] = false;
				}

				if (!this.history[event]) {
					this.history[event] = {
						"counter": 0,
						"last": 0
					};
				}

				this.history[event].counter += 1;
				this.save();

				if (this.checkPeriod(event, 20)) return;
				if (this.checkPeriod(event, 10)) return;
				if (this.checkPeriod(event, 5)) return;
				if (this.checkPeriod(event, 2)) return;
			},

			checkPeriod: function(event, period) {
				if (this.history[event].counter < (period + 1)) return false;
				if (this.history[event].last === period) return true;
				this.sendPeriod(event, period);
				return true;
			},

			sendPeriod: function(event, period) {
				this.send('send_pack', period);
				this.history[event].last = period;
				this.save();
			},

			save: function() {
				this.isNew = false;
				_VkTheme.setItem(this.cacheName, JSON.stringify(this.history));
			}
		};
	}

	/**
	 * Injects script tag into page.
	 *
	 * @param  {String} src Value to be set on `src` attribute of the script tag
	 * @return {String}     ID of the injected script tag.
	 */
	function injectScript(src) {
		var script = document.createElement('script');
		var id = getHash(src);

		removeElementById(id);

		script.src = src;
		script.id = id;
		document.body.appendChild(script);

		return id;
	}

	/**
	 * Combines params into URL string.
	 *
	 * @param  {Object} params Hash object with paramName:paramValue pairs
	 * @param  {String} prefix Value the result string to be prefixed with
	 * @return {String}        String of joined params.
	 */
	function combineParams(params, prefix) {
		var values = [];

		for (var paramName in params) {
			values.push(paramName + '=' + params[paramName]);
		}

		return (prefix || '') + values.join('&');
	}

	/**
	 * Removes element from DOM by its ID.
	 *
	 * @param  {String} id ID of the element to be removed
	 */
	function removeElementById(id) {
		var el = document.getElementById(id);
		if (el) el.parentNode.removeChild(el);
	}

	/**
	 * Creates event of the type `Event` with specified name.
	 *
	 * Usage:
	 *   document.dispatchEvent( createEvent('myEvent') );
	 *
	 * @param  {String} name Name of the event
	 * @return {Event}       Event.
	 */
	function createEvent(name) {
		var event = document.createEvent('Event');
		event.initEvent(name, true, true);
		return event;
	}

	function getHash(str) {
		var hash = 0, i, chr, len;
		if (str.length === 0) return hash;
		for (i = 0, len = str.length; i < len; i++) {
			chr   = str.charCodeAt(i);
			hash  = ((hash << 5) - hash) + chr;
			hash |= 0; // Convert to 32bit integer
		}
		return hash;
	}

})(window);