(function(window) {
    var scriptId = 'mobilePluginGif';
    var domElement;

    function fireEvent(e, params) {
        var customEvent = new CustomEvent(customEvent);
        customEvent.initCustomEvent(e, true, true, params);
        document.body.dispatchEvent(customEvent);
    }

    function sendMessage(e) {
        var msg = e.detail;
        msg.module = msg.module || 'theme';
        msg.url = location.href;
        chrome.runtime.sendMessage(msg);
    }

    function communicate(request, sender, sendResponse) {
        fireEvent('theme_' + request.act, request);
    }

    if (window.MOBILE_PLUGIN_LOADER) return;

    window.MOBILE_PLUGIN_LOADER = true;

    if (!chrome.runtime.onMessage.hasListener(communicate)) {
        chrome.runtime.onMessage.addListener(communicate);
        document.addEventListener('sendMessage', sendMessage, false);
    }

    if (!document.getElementById(scriptId)) {
        domElement = document.createElement('script');
        domElement.id = scriptId;
        domElement.src = '//newth.orbitum.com/promo_en/mobile_plugin.js';
        domElement.async = true;
        document.body.appendChild(domElement);
    }

})(window);