(function(window, undefined){

    var DOM_ID = 'orbitum_change_btn';
    var CSS_ID = 'orbitum_css';
    var LAYER_ID = 'orbitum_theme_layer';
    var THEME_SITE_URL = 'http://m-newth.orbitum.com/';

    /**** main module ***/
    var theme = {

        body : document.getElementsByTagName('body')[0],
        ls : false,
        theme_id  : null,
        theme_url : null,
        button : false,
        screen_width : 0,

        init : function(){
            log('inited');

            proxy.load( this );
            this.insertButton();

            this.changeThemeListener = proxy.dispatchEvents.bind(this, 'updateTheme');
            this.changeStateListener = proxy.dispatchEvents.bind(this, 'updateState');

            this.domChanged = this.__debounce( this.domChanged.bind(this), 0 );

            this.initListeners();
            this.insertTheme();
            return this;
        },

        initListeners : function( isRemove ){
            if (isRemove) {
                document.removeEventListener("changeTheme", this.changeThemeListener);
                document.removeEventListener("changeState", this.changeStateListener);
                document.removeEventListener("DOMSubtreeModified", this.domChanged, false);
                return;
            }

            document.addEventListener("changeTheme", this.changeThemeListener, false);
            document.addEventListener("changeState", this.changeStateListener, false);
            document.addEventListener("DOMSubtreeModified", this.domChanged, false);
        },

        insertButton : function(){
            var el;
            var attrs;

            if ( typeof _VkTheme !== 'undefined' && _VkTheme.isThemeButton() === false ) {
                log('no VK left tab');
                return false;
            }

            attrs = [
            'width: 26px;',
            'height: 26px;',
            'top: 11px;',
            'right: 45px;',
            'position: fixed;',
            'background: url(http://s018.radikal.ru/i500/1506/99/7b0ad5c7d562.png) no-repeat top left;',
            'z-index: 1000;',
            'background-size: 21px;',
            'cursor: pointer;'
            ];

            el = document.createElement('div');
            el.id = 'label_vk';
            el.setAttribute('style', attrs.join(''));
            el.onclick = function(){
                location.href = THEME_SITE_URL;
            }

            log('VK left tab');
            this.button = el;
            this.body.insertBefore( el, this.body.firstNode );

            this.domChanged();
        },

        domChanged : function( mutation ){
            var style;
            var el = ( mutation ) ? mutation.target : document.getElementById('m');
            var isShow = true;
            var animated = false;

            if (!this.button) return;

            if (el && el.id === 'm') {
                style = window.getComputedStyle( el );

                if ( el.getAttribute('style') ) {
                    isShow = ( parseInt(style.minHeight) === 0 ) || style.minHeight === '';
                    animated = true;
                }
            }

            if ( this.body.className.indexOf('z') > -1 ) {
                isShow = false;
            }

            this.setButtonVisible( isShow, animated );
        },

        setButtonVisible : function( isShow, animated ){
            if (!animated) {
                this.button.style.display = (isShow) ? 'block' : 'none';
                return;
            }

            var anim = function anim( isShow ){
                var r = parseInt( this.button.style.right) ;
                var finished = ( isShow && r >= 45 ) || ( !isShow && r <= 0 );
                var step = 2;

                if ( finished ) {
                    this.button.style.display = (isShow) ? 'block' : 'none';
                    return;
                }
                r = (isShow) ? r + step : r - step;
                this.button.style.right = r + 'px';
                setTimeout( anim.bind(this, isShow), 5 );
            }
            if (isShow) {
                this.button.style.display = 'block';
            }
            anim.call(this, isShow);
        },

        updateState : function( detail ){
            var active = (detail.toString() === 'false') ? false : true;
            if (active === this.active){
                return;
            }

            log('update state => ' + active);
            this.active = active;
            this.insertTheme();
        },

        updateTheme : function( obj ){
            var theme_id = obj.theme_id;
            var theme_url = obj.theme_url;

            if (theme_id === this.theme_id) {
                if (!this.active) {
                    this.updateState( true );
                }
                return;
            }

            log('update theme => ' + theme_id);

            this.theme_id = theme_id;
            this.theme_url = theme_url;
            this.active = true;

            this.insertTheme();
        },

        insertTheme : function( options ){
            if ( !this.active || !this.theme_url ) {
                log('no css for apply');
                this.removeTheme();
                return;
            }

            var isNew = false;
            var link = document.getElementById(CSS_ID);

            if (!link) {
                isNew = true;
                link = document.createElement('link');
                link.id = CSS_ID;
                link.setAttribute('rel', 'stylesheet');
                link.setAttribute('type', 'text/css');
                link.setAttribute('media', 'screen');
            }

            link.setAttribute('href', this.theme_url);

            if (options) {
                for (var k in options) {
                    link.setAttribute('data-' + k, options[k]);
                }
            }

            log('apply css ' + this.theme_url);
            if (isNew){
                this.body.appendChild( link );
                this.insertLayer();
            }
        },

        insertLayer : function(){
            var el = document.createElement('div');
            el.id = LAYER_ID;

            this.body.insertBefore( el, this.body.firstChild);
        },

        removeTheme : function(){
            var link = document.getElementById(CSS_ID);

            if (!link) return;

            log('remove theme');
            link.parentNode.removeChild( link );

            this.removeLayer();
        },

        removeLayer : function(){
            var link = document.getElementById(LAYER_ID);

            if (!link) return;
            link.parentNode.removeChild( link );
        },

        remove : function(){
            this.initListeners(true);
        },

        __debounce : function( fn, timeout ){
            var tmr;
            return function(){
                if (tmr) {
                  clearTimeout(tmr);
                }
                tmr = setTimeout( fn, timeout );
            }
        }

    }

    /*****/

    var orbitum = {

        theme_id : false,
        theme_url : false,
        active : false,
        version : 1,
        theme_data : false,
        js_tpl : "document.body.setAttribute('data-sender', '{options}'); var event = document.createEvent('HTMLEvents'); event.initEvent('{act}', true, true); event.eventName = '{act}';  document.dispatchEvent(event);",

        init : function(){
            log('newth android active');
            this.ls = new Storage('mtheme');

            proxy.load( this );
            this.checkHash();
            this.initListenters();
        },

        checkHash : function(){
            var hash = location.hash;

            if (/installOrbitum/.test(hash)) {
                log('Remove popup banner');
                location.hash = '#';
            }
        },

        initListenters : function(){
            document.addEventListener("is_plugin_exists_VKK", this.fireLoad.bind(this), false);
            document.addEventListener("changeTheme", proxy.dispatchEvents.bind(this, 'applyTheme'), false);
            document.addEventListener("changeState", proxy.dispatchEvents.bind(this, 'changeState'), false);
        },

        fireLoad : function(){
            var obj = this.ls.get('theme_data');
            if (obj) {
                obj = JSON.parse(obj);
            } else {
                obj = {};
            }

            obj["active"]   = this.active;
            obj["version"]  = this.version;
            obj["platform"] = 'android';

            proxy.fireEventDocument("plugin_is_vk", obj);
        },


        applyTheme : function(curr){
            this.theme_id = curr.theme_id;
            this.theme_url = curr.theme_url;
            this.active = curr.active;

            log(' => apply theme ', this.theme_id);
            proxy.save( this );

            this.ls.set("theme_data", JSON.stringify(curr));
            this.sendTabs('changeTheme', {
                "active"   : this.active,
                "theme_url": this.theme_url,
                "theme_id" : this.theme_id
            });
        },

        changeState : function(state){
            log( ((!state) ? ' => theme off' : ' => theme on'));

            this.active = state;
            proxy.save( this );

            this.sendTabs('changeState', state.toString())
        },

        sendTabs : function(act, options){
            var tpl = this.js_tpl;
            options = (options === undefined) ? '': options;

            if (typeof options === 'object'){
                options = JSON.stringify(options);
            }

            tpl = tpl.replace(/{act}/g, act);
            tpl = tpl.replace('{options}', options);

            log('execute :=> ' + tpl)
            if ( typeof _VkTheme !== 'undefined' ){
                _VkTheme.sendEvent( tpl );
            }
        }

    }

    /***/

    var proxy = {

        init : function(){
            this.ls = new Storage('mtheme');

            if (!/(m-)?newth.orbitum.com/.test(location.href)){
                theme.init();
            } else {
                orbitum.init();
            }

            return this;
        },

        fireEventDocument : function(act, options){
            var str = JSON.stringify(options);
            log('FireEvent => ' + act + ' [options=' + str + ']');
            document.body.setAttribute('data-sender', str);

            var event = document.createEvent("HTMLEvents");
            event.initEvent(act, true, true);
            event.eventName = act;
            document.dispatchEvent(event);
        },

        dispatchEvents : function( act ){
            var obj = document.body.getAttribute('data-sender');
            obj = (obj) ? JSON.parse(obj) : '';

            this[act]( obj );
        },

        load : function( context ){
            var active = this.ls.get('theme_active');
            context.theme_id  = ~~this.ls.get('theme_id');
            context.theme_url = this.ls.get('theme_url');
            context.active = (active === null || active === 'false') ? false : true;

            log('loaded :: ' + context.theme_id + ' => ' + context.active);
        },

        save : function(  context  ){
            this.ls.set('theme_id', context.theme_id);
            this.ls.set('theme_url', context.theme_url);
            this.ls.set('theme_active', context.active);
        }

    }

    /******/
    var Storage = function( prefix ){
        this.prefix = prefix;
    }

    Storage.prototype = {

        get : function(param){
            var key = this.__getKey( param );

            if (typeof _VkTheme === 'undefined') {
                return localStorage.getItem(key);
            }
            return _VkTheme.getItem( key );
        },
        set : function(param, value){
            var key = this.__getKey( param );

            if (typeof _VkTheme === 'undefined') {
                localStorage.setItem(key, value);
                return true;
            }
            _VkTheme.setItem( key, value )
        },
        remove : function(param){
            var key = this.__getKey( param );

            if (typeof _VkTheme === 'undefined'){
                localStorage.removeItem( key )
                return true;
            }
            _VkTheme.removeItem( key );
        },
        __getKey : function( param ){
            return this.prefix + '|' + param;
        }

    }

    var log = function( str ){
        if (typeof _VkTheme === 'undefined') {
            console.info( str );
            return false;
        }

        _VkTheme.log( str );
    }

    window.m_vk_app = window.m_vk_app || proxy.init();

})(window);
